package app.firezone.synk.network.Adapter;

import android.view.View;
import android.widget.ImageButton;
import android.widget.RelativeLayout;

import com.pierfrancescosoffritti.androidyoutubeplayer.core.customui.utils.FadeViewHelper;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.customui.views.YouTubePlayerSeekBar;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.customui.views.YouTubePlayerSeekBarListener;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.PlayerConstants;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.YouTubePlayer;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.listeners.AbstractYouTubePlayerListener;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.utils.YouTubePlayerTracker;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.views.YouTubePlayerView;
import app.firezone.synk.network.R;

public class PlayerUiController extends AbstractYouTubePlayerListener {

    private  final YouTubePlayerTracker  playerTracker;

    private final YouTubePlayer youTubePlayer;

    private final YouTubePlayerView youTubePlayerView;

    private boolean isFullscreen = false;

    public  PlayerUiController(View controlUi, YouTubePlayer youTubePlayer, YouTubePlayerView youTubePlayerView){

        this.youTubePlayer = youTubePlayer;
        this.youTubePlayerView = youTubePlayerView;
        playerTracker = new YouTubePlayerTracker();
        youTubePlayer.addListener(playerTracker);


        initViews(controlUi);

    }

    private void initViews(View view) {

        View  container = view.findViewById(R.id.playerContainer);
        RelativeLayout relativeLayout = view.findViewById(R.id.root);
        YouTubePlayerSeekBar seekBar = view.findViewById(R.id.playerSeekbar);
        ImageButton pausePlay = view.findViewById(R.id.pausePlay);
        ImageButton fullscreen = view.findViewById(R.id.toggleFullscreen);
        youTubePlayer.addListener(seekBar);


        seekBar.setYoutubePlayerSeekBarListener(new YouTubePlayerSeekBarListener() {
            @Override
            public void seekTo(float v) {
                youTubePlayer.seekTo(v);
            }
        });


        pausePlay.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (playerTracker.getState() == PlayerConstants.PlayerState.PLAYING){
                    pausePlay.setImageResource(R.drawable.play_circle_filled_24);
                    youTubePlayer.pause();
                }
                else {
                    pausePlay.setImageResource(R.drawable.pause_circle_filled_24);
                    youTubePlayer.play();
                }
            }
        });




        fullscreen.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (isFullscreen){
                    youTubePlayerView.wrapContent();

                }else {
                    youTubePlayerView.matchParent();

                }

                isFullscreen = !isFullscreen;
            }
        });


        FadeViewHelper fadeViewHelper= new FadeViewHelper(container);
        fadeViewHelper.setAnimationDuration(FadeViewHelper.DEFAULT_ANIMATION_DURATION);
        fadeViewHelper.setFadeOutDelay(FadeViewHelper.DEFAULT_FADE_OUT_DELAY);
        youTubePlayer.addListener(fadeViewHelper);

        relativeLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                fadeViewHelper.toggleVisibility();
            }
        });

        container.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                fadeViewHelper.toggleVisibility();
            }
        });


    }

}
